/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.indices.IndexMapping;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ProtectedConfigIndexService
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(ProtectedConfigIndexService.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final SearchGuardPlugin.ProtectedIndices protectedIndices;
    private final ComponentState componentState = new ComponentState(100, null, "protected_config_index_service");
    private final CountAggregation flushPendingIndicesCount = new CountAggregation();
    private final Set<ConfigIndexState> pendingIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<ConfigIndexState> completedIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private static final ImmutableMap<String, Object> INDEX_SETTINGS = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-all", (Object)"index.hidden", (Object)true);
    private final ClusterStateListener clusterStateListener = new ClusterStateListener(){

        public void clusterChanged(ClusterChangedEvent event) {
            ProtectedConfigIndexService.this.threadPool.generic().execute(() -> ProtectedConfigIndexService.this.checkClusterState(event.state()));
        }
    };

    public ProtectedConfigIndexService(Client client, ClusterService clusterService, ThreadPool threadPool, SearchGuardPlugin.ProtectedIndices protectedIndices) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.protectedIndices = protectedIndices;
        clusterService.addListener(this.clusterStateListener);
        this.componentState.addMetrics("flush_pending_indices", (Measurement)this.flushPendingIndicesCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentState createIndex(ConfigIndex configIndex) {
        ConfigIndexState configIndexState = new ConfigIndexState(configIndex);
        ComponentState componentState = this.componentState;
        synchronized (componentState) {
            this.componentState.addPart(configIndexState.moduleState);
        }
        this.protectedIndices.add(configIndex.getName());
        if (!this.ready.get()) {
            this.pendingIndices.add(configIndexState);
        } else {
            this.createIndexNow(configIndexState, this.clusterService.state());
        }
        return configIndexState.moduleState;
    }

    public DocNode flushPendingIndices() {
        return this.flushPendingIndices(this.clusterService.state());
    }

    public DocNode flushPendingIndices(ClusterState clusterState) {
        try {
            if (this.pendingIndices.isEmpty()) {
                this.componentState.setInitialized();
                return DocNode.of((String)"info", (Object)"completed");
            }
            this.flushPendingIndicesCount.increment();
            HashSet<ConfigIndexState> pendingIndices = new HashSet<ConfigIndexState>(this.pendingIndices);
            this.pendingIndices.removeAll(pendingIndices);
            HashMap<String, String> result = new HashMap<String, String>();
            for (ConfigIndexState configIndex : pendingIndices) {
                String configIndexResult = this.createIndexNow(configIndex, clusterState);
                result.put(configIndex.getName(), configIndexResult);
            }
            return DocNode.wrap(result);
        }
        catch (Exception e) {
            log.error("Error in flushPendingIndices()", (Throwable)e);
            this.componentState.addLastException("flushPendingIndices", (Throwable)e);
            this.componentState.setFailed((Throwable)e);
            return DocNode.of((String)"error", (Object)e.getMessage());
        }
    }

    public void onNodeStart() {
        this.ready.set(true);
        this.threadPool.generic().execute(() -> this.checkClusterState(this.clusterService.state()));
    }

    private void checkClusterState(ClusterState clusterState) {
        try {
            if (!this.ready.get()) {
                this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_node_started");
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("checkClusterState()\npendingIndices: " + this.pendingIndices);
            }
            if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_state_recovery");
                log.trace("State not yet recovered. Waiting more.");
                return;
            }
            this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_master");
            if (clusterState.nodes().isLocalNodeElectedMaster() || clusterState.nodes().getMasterNode() != null) {
                this.flushPendingIndices(clusterState);
            }
        }
        catch (Exception e) {
            log.error("Error in checkClusterState()", (Throwable)e);
            this.componentState.addLastException("checkClusterState", (Throwable)e);
            this.componentState.setFailed((Throwable)e);
        }
        if (!this.pendingIndices.isEmpty()) {
            this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueSeconds((long)30L), "generic", () -> this.checkClusterState(this.clusterService.state()));
        }
    }

    private String createIndexNow(final ConfigIndexState configIndex, ClusterState clusterState) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("createIndexNow(" + configIndex + ")");
            }
            if (this.completedIndices.contains(configIndex)) {
                if (log.isTraceEnabled()) {
                    log.trace(configIndex + " is already completed");
                }
                return "completed";
            }
            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(configIndex.getName());
            if (indexAbstraction != null) {
                IndexMetadata indexMetadata = clusterState.getMetadata().index(indexAbstraction.getWriteIndex());
                if (log.isTraceEnabled()) {
                    log.trace(configIndex + " does already exist.");
                }
                if (!indexMetadata.isHidden()) {
                    if (log.isInfoEnabled()) {
                        log.info("Index settings for " + configIndex.getName() + " needs to be updated");
                    }
                    this.client.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{indexMetadata.getIndex().getName()}).settings(Settings.builder().put("index.hidden", true).build()), (ActionListener)new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse response) {
                            log.info("Settings update for " + configIndex + " successful");
                        }

                        public void onFailure(Exception e) {
                            log.error("Settings update failed for " + configIndex, (Throwable)e);
                        }
                    });
                }
                if (configIndex.mappingUpdates.size() != 0) {
                    SortedMap availableUpdates;
                    int mappingVersion = this.getMappingVersion(configIndex, clusterState);
                    if (log.isTraceEnabled()) {
                        log.trace("Mapping version of index: " + mappingVersion);
                    }
                    if ((availableUpdates = configIndex.mappingUpdates.tailMap(mappingVersion)).size() != 0) {
                        Integer patchFrom = availableUpdates.firstKey();
                        Map patch = (Map)configIndex.mappingUpdates.get(patchFrom);
                        if (log.isInfoEnabled()) {
                            log.info("Updating mapping of index " + configIndex.getName() + " from version " + mappingVersion + " to version " + configIndex.mappingVersion);
                        }
                        configIndex.moduleState.setState(ComponentState.State.INITIALIZING, "mapping_update");
                        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{configIndex.getName()}).type("_doc").source(patch);
                        if (log.isDebugEnabled()) {
                            log.debug(Strings.toString((ToXContent)putMappingRequest));
                        }
                        this.client.admin().indices().putMapping(putMappingRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                            public void onResponse(AcknowledgedResponse response) {
                                configIndex.moduleState.setState(ComponentState.State.INITIALIZING, "mapping_updated");
                                ProtectedConfigIndexService.this.completedIndices.add(configIndex);
                                configIndex.setCreated(true);
                                if (configIndex.getListener() != null) {
                                    configIndex.waitForYellowStatus();
                                } else {
                                    configIndex.moduleState.setInitialized();
                                }
                            }

                            public void onFailure(Exception e) {
                                log.error("Mapping update failed for " + configIndex, (Throwable)e);
                                configIndex.setFailed(e);
                                configIndex.moduleState.setState(ComponentState.State.FAILED, "mapping_update_failed");
                            }
                        });
                        return "mapping_updated";
                    }
                }
                this.completedIndices.add(configIndex);
                configIndex.setCreated(true);
                if (configIndex.getListener() != null) {
                    configIndex.waitForYellowStatus();
                } else {
                    configIndex.moduleState.setInitialized();
                }
                return "exists";
            }
            if (!clusterState.nodes().isLocalNodeElectedMaster()) {
                this.pendingIndices.add(configIndex);
                configIndex.moduleState.setState(ComponentState.State.INITIALIZING, "waiting_for_master");
                return "waiting_for_master";
            }
            CreateIndexRequest request = new CreateIndexRequest(configIndex.getName());
            if (configIndex.getMapping() != null) {
                request.mapping("_doc", configIndex.getMapping());
            }
            request.settings(INDEX_SETTINGS);
            if (log.isDebugEnabled()) {
                log.debug("Creating index " + request.index() + ":\n" + Strings.toString((ToXContent)request, (boolean)true, (boolean)true));
            }
            this.completedIndices.add(configIndex);
            configIndex.moduleState.setState(ComponentState.State.INITIALIZING, "creating");
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.client.admin().indices().create(request).actionGet();
            configIndex.setCreated(true);
            if (createIndexResponse.isAcknowledged()) {
                if (log.isDebugEnabled()) {
                    log.debug("Created " + configIndex + ": " + Strings.toString((ToXContent)createIndexResponse));
                }
                if (configIndex.getListener() != null) {
                    configIndex.waitForYellowStatus();
                } else {
                    configIndex.moduleState.setInitialized();
                }
                return "created";
            }
            throw new Exception("Index creation was not acknowledged");
        }
        catch (ResourceAlreadyExistsException e) {
            configIndex.setCreated(true);
            if (configIndex.getListener() != null) {
                configIndex.waitForYellowStatus();
            } else {
                configIndex.moduleState.setInitialized();
            }
            return "created_by_other_node";
        }
        catch (Exception e) {
            this.pendingIndices.add(configIndex);
            log.error("Error while creating index " + configIndex, (Throwable)e);
            configIndex.moduleState.addLastException("createIndexNow", (Throwable)e);
            return "error";
        }
    }

    private int getMappingVersion(ConfigIndexState configIndex, ClusterState clusterState) {
        IndexMetadata index = clusterState.getMetadata().index(((IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(configIndex.getName())).getWriteIndex());
        MappingMetadata mapping = index.mapping();
        if (mapping == null) {
            return 0;
        }
        Object meta = mapping.getSourceAsMap().get("_meta");
        if (!(meta instanceof Map)) {
            return 0;
        }
        Object version = ((Map)meta).get("version");
        if (version instanceof Number) {
            return ((Number)version).intValue();
        }
        return 0;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public static class TriggerConfigIndexCreationAction
    extends ActionType<Response> {
        public static final TriggerConfigIndexCreationAction INSTANCE = new TriggerConfigIndexCreationAction();
        public static final String NAME = "cluster:admin:searchguard:internal/indices/create";
        public static final RestApi REST_API = new RestApi().responseHeaders(SearchGuardVersion.header()).handlesPost("/_searchguard/internal/indices/create").with((ActionType)INSTANCE, (params, body) -> new Request()).name("/_searchguard/internal/indices/create");

        protected TriggerConfigIndexCreationAction() {
            super(NAME, Response::new);
        }

        public static class TransportAction
        extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse> {
            private final ProtectedConfigIndexService protectedConfigIndexService;

            @Inject
            public TransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ProtectedConfigIndexService protectedConfigIndexService) {
                super(TriggerConfigIndexCreationAction.NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "management", NodeResponse.class);
                this.protectedConfigIndexService = protectedConfigIndexService;
            }

            protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
                return new NodeResponse(in);
            }

            protected Response newResponse(Request request, List<NodeResponse> responses, List<FailedNodeException> failures) {
                return new Response(this.clusterService.getClusterName(), responses, failures);
            }

            protected NodeResponse nodeOperation(NodeRequest request) {
                return new NodeResponse(this.clusterService.localNode(), this.protectedConfigIndexService.flushPendingIndices());
            }

            protected NodeRequest newNodeRequest(Request request) {
                return new NodeRequest();
            }
        }

        public static class NodeResponse
        extends BaseNodeResponse
        implements ToXContentObject {
            private final DocNode result;

            public NodeResponse(StreamInput in) throws IOException {
                super(in);
                this.result = DocNode.wrap((Object)in.readMap());
            }

            public NodeResponse(DiscoveryNode node, DocNode result) {
                super(node);
                this.result = result;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeMap((Map)this.result.toMap());
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.map((Map)this.result.toMap());
                return builder;
            }
        }

        public static class NodeRequest
        extends BaseNodeRequest {
            public NodeRequest(StreamInput in) throws IOException {
                super(in);
            }

            public NodeRequest() {
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
            }
        }

        public static class Response
        extends BaseNodesResponse<NodeResponse>
        implements StatusToXContentObject {
            public Response(StreamInput in) throws IOException {
                super(in);
            }

            public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
                super(clusterName, nodes, failures);
            }

            public List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
                return in.readList(NodeResponse::new);
            }

            public void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
                out.writeList(nodes);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("nodes", (Object)this.getNodesMap());
                if (this.hasFailures()) {
                    builder.field("failures");
                    builder.startArray();
                    for (FailedNodeException failure : this.failures()) {
                        builder.startObject();
                        failure.toXContent(builder, params);
                        builder.endObject();
                    }
                    builder.endArray();
                }
                builder.endObject();
                return builder;
            }

            public RestStatus status() {
                return RestStatus.OK;
            }
        }

        public static class Request
        extends BaseNodesRequest<Request> {
            Request() {
                super(new String[0]);
            }

            Request(StreamInput in) throws IOException {
                super(in);
            }

            Request(Collection<DiscoveryNode> concreteNodes) {
                super(concreteNodes.toArray(new DiscoveryNode[concreteNodes.size()]));
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
            }
        }
    }

    public static interface FailureListener {
        public void onSuccess();

        public void onFailure(Exception var1);
    }

    @FunctionalInterface
    public static interface IndexReadyListener {
        public void onIndexReady(FailureListener var1);
    }

    public static class ConfigIndex {
        private String name;
        private Map<String, Object> mapping;
        private int mappingVersion;
        private IndexReadyListener listener;
        private String[] indexDependencies = new String[0];
        private SortedMap<Integer, Map<String, Object>> mappingUpdates = new TreeMap<Integer, Map<String, Object>>();

        public ConfigIndex(String name) {
            this.name = name;
        }

        public ConfigIndex mapping(IndexMapping mapping) {
            this.mapping = mapping.toDocNode().toMap();
            return this;
        }

        public ConfigIndex mapping(Map<String, Object> mapping) {
            this.mapping = mapping;
            this.mappingVersion = 1;
            return this;
        }

        public ConfigIndex mapping(Map<String, Object> mapping, int mappingVersion) {
            this.mapping = new HashMap<String, Object>(mapping);
            this.mappingVersion = mappingVersion;
            this.mapping.put("_meta", ImmutableMap.of((Object)"version", (Object)mappingVersion));
            return this;
        }

        public ConfigIndex mappingUpdate(int fromVersion, Map<String, Object> mappingDelta) {
            if (this.mappingVersion == 0) {
                throw new IllegalStateException("A mapping needs to be defined first");
            }
            mappingDelta = new HashMap<String, Object>(mappingDelta);
            mappingDelta.put("_meta", ImmutableMap.of((Object)"version", (Object)this.mappingVersion));
            this.mappingUpdates.put(fromVersion, mappingDelta);
            return this;
        }

        public ConfigIndex onIndexReady(IndexReadyListener listener) {
            this.listener = listener;
            return this;
        }

        public ConfigIndex dependsOnIndices(String ... indexDependencies) {
            if (indexDependencies != null) {
                this.indexDependencies = indexDependencies;
            }
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getMapping() {
            return this.mapping;
        }

        public SortedMap<Integer, Map<String, Object>> getMappingUpdates() {
            return this.mappingUpdates;
        }
    }

    private class ConfigIndexState {
        private final String name;
        private final Map<String, Object> mapping;
        private final int mappingVersion;
        private final SortedMap<Integer, Map<String, Object>> mappingUpdates;
        private final IndexReadyListener listener;
        private final String[] allIndices;
        private final ComponentState moduleState;
        private volatile long createdAt;

        ConfigIndexState(ConfigIndex configIndex) {
            this.name = configIndex.name;
            this.mapping = configIndex.mapping;
            this.mappingVersion = configIndex.mappingVersion;
            this.listener = configIndex.listener;
            this.moduleState = new ComponentState(5, "index", configIndex.name);
            this.mappingUpdates = configIndex.mappingUpdates;
            if (configIndex.indexDependencies == null || configIndex.indexDependencies.length == 0) {
                this.allIndices = new String[]{this.name};
            } else {
                this.allIndices = new String[configIndex.indexDependencies.length + 1];
                this.allIndices[0] = this.name;
                System.arraycopy(configIndex.indexDependencies, 0, this.allIndices, 1, configIndex.indexDependencies.length);
            }
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getMapping() {
            return this.mapping;
        }

        public String toString() {
            return "ConfigIndex [name=" + this.name + "]";
        }

        public void setFailed(Exception failed) {
            this.moduleState.setFailed((Throwable)failed);
        }

        public void setCreated(boolean created) {
            if (created) {
                this.moduleState.setInitialized();
                this.createdAt = System.currentTimeMillis();
            }
        }

        public IndexReadyListener getListener() {
            return this.listener;
        }

        public void waitForYellowStatus() {
            if (log.isTraceEnabled()) {
                log.trace("waitForYellowStatus(" + this + ")");
            }
            this.moduleState.setState(ComponentState.State.INITIALIZING, "waiting_for_yellow_status");
            this.moduleState.startNextTry();
            ProtectedConfigIndexService.this.client.admin().cluster().health(new ClusterHealthRequest(this.allIndices).waitForYellowStatus().timeout(TimeValue.timeValueMinutes((long)5L)), (ActionListener)new ActionListener<ClusterHealthResponse>(){

                public void onResponse(ClusterHealthResponse clusterHealthResponse) {
                    if (clusterHealthResponse.getStatus() == ClusterHealthStatus.YELLOW || clusterHealthResponse.getStatus() == ClusterHealthStatus.GREEN) {
                        if (log.isDebugEnabled()) {
                            log.debug(ConfigIndexState.this + " reached status " + Strings.toString((ToXContent)clusterHealthResponse));
                        }
                        ProtectedConfigIndexService.this.threadPool.generic().submit(() -> ConfigIndexState.this.tryOnIndexReady());
                        return;
                    }
                    if (ConfigIndexState.this.isTimedOut()) {
                        ConfigIndexState.this.moduleState.setFailed("Index " + ConfigIndexState.this.name + " is has not become ready. Giving up");
                        ConfigIndexState.this.moduleState.setDetailJson(Strings.toString((ToXContent)clusterHealthResponse));
                        log.error("Index " + ConfigIndexState.this.name + " is has not become ready:\n" + clusterHealthResponse + "\nGiving up.");
                        return;
                    }
                    if (ConfigIndexState.this.isLate()) {
                        log.error("Index " + ConfigIndexState.this.name + " is not yet ready:\n" + clusterHealthResponse + "\nRetrying.");
                        ConfigIndexState.this.moduleState.setDetailJson(Strings.toString((ToXContent)clusterHealthResponse));
                    } else if (log.isTraceEnabled()) {
                        log.trace("Index " + ConfigIndexState.this.name + " is not yet ready:\n" + clusterHealthResponse + "\nRetrying.");
                    }
                    ProtectedConfigIndexService.this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueSeconds((long)5L), "generic", () -> ConfigIndexState.this.waitForYellowStatus());
                }

                public void onFailure(Exception e) {
                    if (ConfigIndexState.this.isTimedOut()) {
                        log.error("Index " + ConfigIndexState.this.name + " is has not become ready. Giving up.", (Throwable)e);
                        ConfigIndexState.this.moduleState.setFailed((Throwable)e);
                        return;
                    }
                    if (ConfigIndexState.this.isLate()) {
                        log.warn("Index " + ConfigIndexState.this.name + " is not yet ready. Retrying.", (Throwable)e);
                        ConfigIndexState.this.moduleState.addLastException("waiting_for_yellow_status", (Throwable)e);
                    } else if (log.isTraceEnabled()) {
                        log.trace("Index " + ConfigIndexState.this.name + " is not yet ready. Retrying.", (Throwable)e);
                    }
                    ProtectedConfigIndexService.this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueSeconds((long)5L), "generic", () -> ConfigIndexState.this.waitForYellowStatus());
                }
            });
        }

        private void tryOnIndexReady() {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("tryOnIndexReady(" + this + ")");
                }
                this.moduleState.setState(ComponentState.State.INITIALIZING, "final_probe");
                this.moduleState.startNextTry();
                this.listener.onIndexReady(new FailureListener(){

                    @Override
                    public void onFailure(Exception e) {
                        if (ConfigIndexState.this.isTimedOut()) {
                            log.error("Initialization for " + ConfigIndexState.this.name + " failed. Giving up.", (Throwable)e);
                            ConfigIndexState.this.moduleState.setFailed((Throwable)e);
                            return;
                        }
                        if (ConfigIndexState.this.isLate()) {
                            log.warn("Initialization for " + ConfigIndexState.this.name + " not yet successful. Retrying.", (Throwable)e);
                        } else if (log.isTraceEnabled()) {
                            log.trace("Initialization for " + ConfigIndexState.this.name + " not yet successful. Retrying.", (Throwable)e);
                        }
                        ProtectedConfigIndexService.this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueSeconds((long)5L), "generic", () -> ConfigIndexState.this.tryOnIndexReady());
                    }

                    @Override
                    public void onSuccess() {
                        ConfigIndexState.this.moduleState.setInitialized();
                    }
                });
            }
            catch (Exception e) {
                log.error("Error in onIndexReady of " + this, (Throwable)e);
            }
        }

        private boolean isTimedOut() {
            return System.currentTimeMillis() > this.createdAt + 86400000L;
        }

        private boolean isLate() {
            return System.currentTimeMillis() > this.createdAt + 60000L;
        }
    }
}

